#!/usr/bin/env bash
#  Copyright (c) 2022-2023, Ciena Corporation
#  All rights reserved.

set -e

# Check that the configuration file path was supplied
if [ "$#" -eq 0 ]; then
  echo "ERROR=Unable to load ConfD Encrypted Strings; ConfD keys filepath not supplied."
  exit 1
fi

# Find the ssh-keygen and xmllint executables used in this script
# $ apt-file search /usr/bin/ssh-keygen
# openssh-client: /usr/bin/ssh-keygen
# openssh-client-ssh1: /usr/bin/ssh-keygen1
OPENSSL=$(which ssh-keygen)
# $ apt-file search /usr/bin/xmllint
# libxml2-utils: /usr/bin/xmllint
XMLLINT=$(which xmllint)

SSH_KEY_DIR=$(${XMLLINT} --xpath "//*[local-name()='aaa']/*[local-name()='sshServerKeyDir']/text()" $1)

# Check if the keys need to be created
## $OPENSSL genpkey -algorithm RSA -pkeyopt rsa_keygen_bits:2048 -outform PEM 2>/dev/null

if [ -d "${SSH_KEY_DIR}" ] && [ -n "$(ls -A ${SSH_KEY_DIR})" ]; then
    echo "SSH hostkey already installed"
else
    echo "Generating default SSH hostkey (this may take some time)"
    mkdir -p ${SSH_KEY_DIR}
    # Generate the RSA key
    RSA_KEY=${SSH_KEY_DIR}/ssh_host_rsa_key
    ssh-keygen -t rsa -b 3072 -N "" -C "confd@${HOSTNAME}" -q -f ${RSA_KEY}

    # Generate the EdDSA key
    EDDSA_KEY=${SSH_KEY_DIR}/ssh_host_ed25519_key
    ssh-keygen -t ed25519 -N "" -C "confd@${HOSTNAME}" -q -f ${EDDSA_KEY}
    echo "SSH hostkey generated"
fi
