"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

public_endpoint_prefixes = [
    "controllers",
    "cascading",
    "switches/configs",
    "switches/automation",
    "olts",
    "onus",
    'dpg',
    "cpes",
    "files",
    "slas",
    "service-configs",
    "databases",
    "users",
    "downstream-maps",
    "tasks"
]


# =======================================
# ========= Preprocessing Hooks =========
# =======================================

def exclude_private_endpoints(endpoints):
    """ Filters private endpoints from generated list so they do not appear in the documentation """

    def filter_endpoints(endpoint):
        (path, _, _, _) = endpoint

        for prefix in public_endpoint_prefixes:
            if prefix in path:
                return True

        return False

    return filter(filter_endpoints, endpoints)
