"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('', views.Manage.as_view(), name='manage_databases'),
    path('selection/', views.Select.as_view(), name='select_database'),
    path('session/', views.SessionOnly.as_view(), name='select_database_for_session'),
    path('stats/<str:database_id>/', views.Stats.as_view(), name='check_database_stats'),
    path('status/', views.ConnectionStatus.as_view(), name='check_database_statuses'),
    path('status/<str:database_id>/', views.OneConnectionStatus.as_view(), name='check_database_status'),
    path('<str:database_id>/', views.ManageOne.as_view(), name='manage_databases'),
]
