"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.contrib.auth.mixins import LoginRequiredMixin
from rest_framework.generics import GenericAPIView
from drf_spectacular.utils import extend_schema
from rest_framework import status

from utils.schema_helpers import ResponseExample
from utils.tools import PonManagerApiResponse
import version as ponmgr_version


# ==================================================
# ========= PON Manager Version Info View ==========
# ==================================================
class Version(LoginRequiredMixin, GenericAPIView):
    raise_exception = True
    queryset = ''

    @extend_schema(
        operation_id="get_ponmgr_version",
        responses={
            200: ResponseExample(200),
            403: ResponseExample(403),
            500: ResponseExample(500),
        },
        tags=['ponmgr', 'version']
    )
    def get(self, request, version):
        """Get the version information for PON Manager"""
        res_data = {
            "Version": ponmgr_version.VERSION,
            "Build Date": ponmgr_version.BUILD_DATE,
            "Build SHA": ponmgr_version.BUILD_SHA,
            "Build OS": ponmgr_version.BUILD_OS
        }

        return PonManagerApiResponse(status=status.HTTP_200_OK, data=res_data)
