"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path
from drf_spectacular.views import SpectacularYAMLAPIView, SpectacularRedocView
from .views import ENABLE_LIVE_DOCS

urlpatterns = [
    path('schema/', SpectacularYAMLAPIView.as_view(), name="schema")
]

# Only allow access to live documentation if it is enabled in the tibit settings database
if ENABLE_LIVE_DOCS:
    urlpatterns += [
        path('', SpectacularRedocView().as_view(url_name='schema'), name='docs')
    ]
