#!/usr/bin/env bash
#
# Wrapper for starting the netopeer2-server.
#

set -e

# Get the Log Level 0, 1, or 2.
if ! LOG_LEVEL=$(jq -e '.Netopeer2."Log Level"' /etc/tibit/netconf/NetconfInit.json); then
    LOG_LEVEL=1
fi

if ! SYSREPO_TIMEOUT=$(jq -e '.Netopeer2."Sysrepo Timeout"' /etc/tibit/netconf/NetconfInit.json); then
    SYSREPO_TIMEOUT=55
fi

echo "Starting netopeer2-server -v ${LOG_LEVEL} -t ${SYSREPO_TIMEOUT} $@"
exec "/opt/tibit/netconf/bin/netopeer2-server" "-v" "${LOG_LEVEL}" "-t" "${SYSREPO_TIMEOUT}" "$@"