#!/usr/bin/env bash
#--------------------------------------------------------------------------#
# Copyright (C) 2015 - 2022 by Tibit Communications, Inc.                  #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
#                                                                          #
#--------------------------------------------------------------------------#

VERSION=R3.2.0
LogFile=uninstall.log

exec > >( tee -a "${LogFile}" )
exec 2> >( tee -a "${LogFile}" >&2 )

if [[ $(id -u) -ne 0 ]] ; then 
    echo "Please run as root"
    exit 1
fi

echo "Stopping apache2 service....."
service apache2 stop

echo "Removing tibit-ponmgr....."
sudo apt-get remove tibit-ponmgr --purge -y
sudo rm -rf /etc/tibit/ponmgr
sudo rm -rf /opt/tibit/ponmgr

echo "Removing apache2....."
sudo apt-get remove apache2 --purge -y

echo "Stopping tibit-poncntl service....."
sudo service tibit-poncntl stop

echo "Removing tibit-poncntl...."
sudo apt-get purge tibit-poncntl -y
sudo rm -rf /opt/tibit/poncntl

echo "Stopping tibit-netconf service....."
sudo service tibit-netconf stop

echo "Removing tibit-netconf....."
sudo apt-get purge tibit-netconf -y

echo "Removing tibit-snmp....."
sudo apt-get purge tibit-snmp -y

echo "Stopping mongodb service....."
sudo service mongod stop

echo "Removing mongodb....."
sudo apt-get purge mongodb-org* -y

echo "Removing mongodb logs....."
sudo rm -rf /var/log/mongodb
sudo rm -rf /mongodb/
sudo rm /etc/logrotate.d/mongod.conf

echo "Removing mongodb configurations....."
sudo rm -rf /var/lib/mongodb
sudo rm -rf /data
sudo rm -rf /tmp/mongodb-*.sock
sudo rm /etc/ssl/mongodb-keyfile

echo "Removing Tibit directories....."
sudo rm -rf /opt/tibit
sudo rm -rf /etc/tibit
sudo rm -rf /var/log/tibit
sudo rm -rf /etc/apache2/sites-available/tibit*
