#!/usr/bin/env python3
# --------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# --------------------------------------------------------------------------#

# Usage: ./drop_collections.py --db <mongodb_uri>/<database>
# e.g., ./drop_collections.py --db mongodb://10.2.10.222:27017/tibit_pon_controller

import sys
import json
import pymongo
from bson.json_util import dumps
import argparse

parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
parser.add_argument("-d",
                    "--db",
                    dest="db_uri",
                    action="store",
                    default='mongodb://127.0.0.1:27017/tibit_pon_controller',
                    required=False,
                    help="Database uri (e.g., mongodb://127.0.0.1:27017/tibit_pon_controller)")
args = parser.parse_args()

try:
    # Connect to the MongoDB Server as specified in the mongodb:// connection URI
    db_client = pymongo.MongoClient(args.db_uri)
    print("{}".format(db_client))

    # Get a handle to the database reference in the mongodb:// connection URI
    db = db_client.get_default_database()
    print("{}".format(db))

    # All collections in DB
    all_collections = db.list_collection_names()

    # Get the old stat and syslog collection names
    # OLT
    olt_stat_colls = list(filter(lambda x: "STATS-OLT-" in x, all_collections))
    olt_syslog_colls = list(filter(lambda x: "SYSLOG-OLT-" in x, all_collections))
    # ONU
    onu_stat_colls = list(filter(lambda x: "STATS-ONU-" in x, all_collections))
    onu_syslog_colls = list(filter(lambda x: "SYSLOG-ONU-" in x, all_collections))
    # Controller
    cntl_stat_colls = list(filter(lambda x: "STATS-CNTL-" in x, all_collections))
    cntl_syslog_colls = list(filter(lambda x: "SYSLOG-CNTL-" in x, all_collections))
    # PON Auto
    pa_stat_colls = list(filter(lambda x: "STATS-AUTO-" in x, all_collections))
    pa_syslog_colls = list(filter(lambda x: "SYSLOG-AUTO-" in x, all_collections))


    def drop_collections(collections):
        for collection_name in collections:
            db[collection_name].drop()


    print(("Dropping OLT stats from - {} - collections").format(len(olt_stat_colls)))
    drop_collections(olt_stat_colls)
    print(("Dropping OLT system logs from - {} - collections").format(len(olt_syslog_colls)))
    drop_collections(olt_syslog_colls)

    print(("Dropping ONU stats from - {} - collections").format(len(onu_stat_colls)))
    drop_collections(onu_stat_colls)
    print(("Dropping ONU system logs from - {} - collections").format(len(onu_syslog_colls)))
    drop_collections(onu_syslog_colls)

    print(("Dropping CNTL stats from - {} - collections").format(len(cntl_stat_colls)))
    drop_collections(cntl_stat_colls)
    print(("Dropping CNTL system logs from - {} - collections").format(len(cntl_syslog_colls)))
    drop_collections(cntl_syslog_colls)

    print(("Dropping AUTO stats from - {} - collections").format(len(pa_stat_colls)))
    drop_collections(pa_stat_colls)
    print(("Dropping AUTO system logs from - {} - collections").format(len(pa_syslog_colls)))
    drop_collections(pa_syslog_colls)


except Exception as err:
    print("An exception has occurred!")
    print(err)
else:
    print("************* Collection drops sucessful! *************")
